clear all
set more off


*** STEP0
* Run next 3 lines once to install needed packages 
*ssc install spmap
*ssc install shp2dta
*ssc install mif2dta


*** STEP1 
* Convert map all_NUTS2.shp with all regions into stata format 
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"
shp2dta using all_NUTS2, database(all_NUTS2_DB) coordinates(all_NUTS2_COORD) genid(_ID) replace


*** STEP2
* create bridge for merging map and unemployment data 
use all_NUTS2_DB, clear
keep CODE _ID
duplicates drop
gen nuts=CODE

* ----------------->>> REPLACE NUTS MANUALLY (compare CODE with nuts from .dta) <<<------------------
replace nuts="BE1" if nuts=="BE10"
replace nuts="DEF" if nuts=="DEF0"
replace nuts="ITH1&ITH2" if nuts=="ITH1"
replace nuts="ITH1&ITH2" if nuts=="ITH2"
replace nuts="NL21&NL23" if nuts=="NL21"
replace nuts="NL21&NL23" if nuts=="NL23"
replace nuts="DE71&DE72" if nuts=="DE71"
replace nuts="DE71&DE72" if nuts=="DE72"
replace nuts="DE91&DE92" if nuts=="DE91"
replace nuts="DE91&DE92" if nuts=="DE92"
replace nuts="FR82&FR83" if nuts=="FR82"
replace nuts="FR82&FR83" if nuts=="FR83"


replace nuts="CA: Alberta" if nuts=="AB"
replace nuts="US: AK" if nuts=="AK"
replace nuts="US: AL" if nuts=="AL"
replace nuts="US: AR" if nuts=="AR"
replace nuts="US: AZ" if nuts=="AZ"
replace nuts="CA: British Columbia" if nuts=="BC"
replace nuts="US: CA" if nuts=="CA"
replace nuts="US: CO" if nuts=="CO"
replace nuts="US: CT" if nuts=="CT"
replace nuts="US: DC" if nuts=="DC"
replace nuts="US: DE" if nuts=="DE"
replace nuts="US: FL" if nuts=="FL"
replace nuts="US: GA" if nuts=="GA"
replace nuts="US: HI" if nuts=="HI"
replace nuts="US: IA" if nuts=="IA"
replace nuts="US: ID" if nuts=="ID"
replace nuts="US: IL" if nuts=="IL"
replace nuts="US: IN" if nuts=="IN"
replace nuts="US: KS" if nuts=="KS"
replace nuts="US: KY" if nuts=="KY"
replace nuts="US: LA" if nuts=="LA"
replace nuts="US: MA" if nuts=="MA"
replace nuts="CA: Manitoba" if nuts=="MB"
replace nuts="US: MD" if nuts=="MD"
replace nuts="US: ME" if nuts=="ME"
replace nuts="US: MI" if nuts=="MI"
replace nuts="US: MN" if nuts=="MN"
replace nuts="US: MO" if nuts=="MO"
replace nuts="US: MS" if nuts=="MS"
replace nuts="US: MT" if nuts=="MT"
replace nuts="CA: New Brunswick" if nuts=="NB"
replace nuts="US: NC" if nuts=="NC"
replace nuts="US: ND" if nuts=="ND"
replace nuts="US: NE" if nuts=="NE"
replace nuts="US: NH" if nuts=="NH"
replace nuts="US: NJ" if nuts=="NJ"
replace nuts="CA: Newfoundland and Labrador" if nuts=="NL"
replace nuts="US: NM" if nuts=="NM"
replace nuts="CA: Nova Scotia" if nuts=="NS"
replace nuts="US: NV" if nuts=="NV"
replace nuts="US: NY" if nuts=="NY"
replace nuts="US: OH" if nuts=="OH"
replace nuts="US: OK" if nuts=="OK"
replace nuts="CA: Ontario" if nuts=="ON"
replace nuts="US: OR" if nuts=="OR"
replace nuts="US: PA" if nuts=="PA"
replace nuts="CA: Quebec" if nuts=="QC"
replace nuts="US: RI" if nuts=="RI"
replace nuts="US: SC" if nuts=="SC"
replace nuts="US: SD" if nuts=="SD"
replace nuts="CA: Saskatchewan" if nuts=="SK"
replace nuts="US: TN" if nuts=="TN"
replace nuts="US: TX" if nuts=="TX"
replace nuts="US: UT" if nuts=="UT"
replace nuts="US: VA" if nuts=="VA"
replace nuts="US: VT" if nuts=="VT"
replace nuts="US: WA" if nuts=="WA"
replace nuts="US: WI" if nuts=="WI"
replace nuts="US: WV" if nuts=="WV"
replace nuts="US: WY" if nuts=="WY"

save all_NUTS2_DB, replace


*** STEP3
* Attach the data to the data with regions' IDs
* Make sure that regions in the unemployment (or any other attached data set) have the same ID's as CODE in the all_NUTS2-file (i.e. 2-letter code for US states and Canadian provinces and NUTS2 -- 2-letter 2-figure -- for European regions)   
joinby nuts using "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\wf_step4001.dta", unmatched(both)
tab _merge
drop if CODE==""
drop _merge

duplicates drop

save vars_for_maps, replace

gen flag_old=1
local new = _N + 1
set obs `new'
replace flag_old=0 if flag_old==.

replace ue2_hyst=-3 if 	flag_old==0	

*** STEP4
* Run the loop to build maps for NA and EU for each variable


foreach x of varlist ue2_hyst {	
replace `x'=. if country=="PT"	
* summarize the current variable to use statistics for constructing legend
quiet sum `x', detail
local p1=r(min)
local label_p1=round(`p1',0.01)
local p5=r(max)
local label_p5=round(`p5',0.01)
* local p3=round(0.5*`p1'+0.5*`p5',0.01)
local p3=8.62
local p2=round(0.25*`p5'+0.75*`p1',0.01)
local p4=round(0.25*`p1'+0.75*`p5',0.01)

* for North America
spmap `x' using all_NUTS2_COORD ///
	if (_ID>317&_ID<382&_ID~=345&_ID~=355&_ID~=373&_ID~=375&_ID~=376&_ID~=379), ///
	id(_ID) fcolor(Rainbow) legstyle(3) clmethod(eqint) clnumber(49) ///
	eirange(`p1' `p5') plotregion(margin(l=20 r=0 t=0 b=0)) ///
	legend(label(1 "No data") label(2 `label_p1') label(14 `p2') label(26 "8.62") label(38 `p4') label(50 `label_p5'))
graph export C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures_maps\map_NA_`x'.png, replace width(800) height(400)

* for Europe
spmap `x' using all_NUTS2_COORD if (_ID>=1&_ID<=20)|(_ID>=27&_ID<=33)|(_ID>=43&_ID<=85)|(_ID>=100&_ID<=117)|(_ID>=119&_ID<=144)|(_ID>=163&_ID<=183)|(_ID>=191&_ID<=202)|(_ID>=226&_ID<=230)|(_ID>=241&_ID<=248)|(_ID>=281&_ID<=317), ///
	id(_ID) fcolor(Rainbow) legstyle(0) clmethod(eqint) clnumber(49) eirange(`p1' `p5') plotregion(margin(l=20 r=0 t=0 b=0)) ///
		legend(label(1 "No data") label(2 `label_p1') label(14 `p2') label(26 "8.62") label(38 `p4') label(50 `label_p5'))
graph export C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures_maps\map_EU_`x'.png, replace width(800) height(600)
}

*===============================================================
*				all maps
*===============================================================

foreach x of varlist ic_EMP_share_female hh_size share_emp_primary_sector share_emp_secondary_sector share_emp_tertiary_sector ///
		share_age_0_24 share_age_55plus share_age_0_14 share_age_15_24 share_age_55_64 share_age_65plus  ///
		year_school logY_ppp log_road_density home_own_rate turnmig_rate netmig_rate ///
		WVS_index_1 WVS_index_2 WVS_index_3 ///
		urban_share_500_y1990 urban_share_100_y1990 urban_share_1000_y1990 {		
* summarize the current variable to use statistics for constructing legend
quiet sum `x', detail
local p1=r(min)
local label_p1=round(`p1',0.01)
local p5=r(max)
local label_p5=round(`p5',0.01)
local p3=round(0.5*`p1'+0.5*`p5',0.01)
local p2=round(0.25*`p5'+0.75*`p1',0.01)
local p4=round(0.25*`p1'+0.75*`p5',0.01)

* for North America
spmap `x' using all_NUTS2_COORD if (_ID>317&_ID<382&_ID~=345&_ID~=355&_ID~=373&_ID~=375&_ID~=376&_ID~=379), ///
	id(_ID) fcolor(Rainbow) legstyle(3) clmethod(eqint) clnumber(49) ///
	eirange(`p1' `p5') plotregion(margin(l=20 r=0 t=0 b=0)) ///
	legend(label(1 "No data") label(2 `label_p1') label(14 `p2') label(26 `p3') label(38 `p4') label(50 `label_p5'))
graph export C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures_maps\maps_NA_`x'.png, replace width(800) height(400)

* for Europe
spmap `x' using all_NUTS2_COORD if (_ID>=1&_ID<=20)|(_ID>=27&_ID<=33)|(_ID>=43&_ID<=85)|(_ID>=100&_ID<=117)|(_ID>=119&_ID<=144)|(_ID>=163&_ID<=183)|(_ID>=191&_ID<=202)|(_ID>=226&_ID<=230)|(_ID>=241&_ID<=248)|(_ID>=281&_ID<=317), id(_ID) fcolor(Rainbow) legstyle(0) clmethod(eqint) clnumber(49) eirange(`p1' `p5') plotregion(margin(l=20 r=0 t=0 b=0)) legend(label(1 "No data") label(2 `label_p1') label(14 `p2') label(26 `p3') label(38 `p4') label(50 `label_p5'))
graph export C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures_maps\maps_EU_`x'.png, replace width(800) height(600)
}

